<?php

namespace App\Events;

use App\Models\ActivityLog;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class AdminNotificationCreated implements ShouldBroadcastNow
{
    use Dispatchable;
    use SerializesModels;

    public function __construct(public ActivityLog $log)
    {
    }

    public function broadcastOn(): array
    {
        $channels = [new PrivateChannel('admin.notifications')];

        if ($this->log->user_id) {
            $channels[] = new PrivateChannel('user.' . $this->log->user_id . '.notifications');
        }

        return $channels;
    }

    public function broadcastAs(): string
    {
        return 'admin.notification';
    }

    public function broadcastWith(): array
    {
        $subject = $this->log->subject_type ? class_basename($this->log->subject_type) : null;
        $summary = $this->log->description ?: trim(implode(' ', array_filter([$this->log->action, $subject])));
        $summary = $summary !== '' ? ucfirst($summary) : 'Activity update';

        return [
            'item' => [
                'id' => $this->log->id,
                'summary' => $summary,
                'user' => $this->log->user?->name ?? 'System',
                'logged_at' => optional($this->log->logged_at)->toIso8601String(),
                'logged_at_label' => optional($this->log->logged_at)->diffForHumans(),
            ],
            'latest_id' => $this->log->id,
        ];
    }
}
