<?php

namespace App\Exceptions;

use RuntimeException;

class PlanLimitReachedException extends RuntimeException
{
    public function __construct(
        public readonly string $limitType,
        public readonly int $used,
        public readonly int $limit
    ) {
        parent::__construct($this->buildMessage());
    }

    private function buildMessage(): string
    {
        return match ($this->limitType) {
            'events' => "Event limit reached. You have {$this->used} of {$this->limit} active event(s).",
            'images' => "Image limit reached. You have {$this->used} of {$this->limit} image(s).",
            'storage' => "Storage limit reached. Used {$this->used} of {$this->limit} bytes.",
            default => 'Plan limit reached.',
        };
    }
}
