<?php

namespace App\Exceptions;

class StorageLimitReachedException extends \RuntimeException
{
    public function __construct(private int $usedBytes, private int $limitBytes)
    {
        parent::__construct('Storage limit reached.');
    }

    public function usedBytes(): int
    {
        return $this->usedBytes;
    }

    public function limitBytes(): int
    {
        return $this->limitBytes;
    }
}
