<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ContactQuery;
use Illuminate\Http\Request;

class ContactQueryController extends Controller
{
    public function index(Request $request)
    {
        $search = $request->query('search');
        $status = $request->query('status');
        $sort = $request->query('sort', 'latest');

        $query = ContactQuery::query();

        if ($search) {
            $query->where(function ($builder) use ($search) {
                $like = '%' . $this->escapeLike($search) . '%';
                $builder->where('first_name', 'like', $like)
                    ->orWhere('last_name', 'like', $like)
                    ->orWhere('email', 'like', $like)
                    ->orWhere('message', 'like', $like);
            });
        }

        if ($status) {
            $query->where('status', $status);
        }

        $query->when($sort === 'oldest', fn ($q) => $q->oldest())
            ->when($sort !== 'oldest', fn ($q) => $q->latest());

        $queries = $query->paginate(15)->withQueryString();

        return view('admin.contact-queries.index', compact('queries', 'search', 'status', 'sort'));
    }

    public function show(ContactQuery $contactQuery)
    {
        if ($contactQuery->status === 'new') {
            $contactQuery->update(['status' => 'read']);
        }

        return view('admin.contact-queries.show', compact('contactQuery'));
    }

    public function destroy(ContactQuery $contactQuery)
    {
        $contactQuery->delete();

        return redirect()->route('admin.contact-queries.index')
            ->with('success', 'Contact query deleted successfully.');
    }

    public function bulkDestroy(Request $request)
    {
        $request->validate(['ids' => 'required|array', 'ids.*' => 'integer']);

        ContactQuery::whereIn('id', $request->ids)->delete();

        return redirect()->route('admin.contact-queries.index')
            ->with('success', count($request->ids) . ' contact queries deleted.');
    }
}
