<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Language;
use App\Support\LocaleSettings;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Schema;

class LocaleController extends Controller
{
    public function update(Request $request): RedirectResponse
    {
        if (! LocaleSettings::isEnabled()) {
            return back()->with('error', 'Multi-language support is disabled.');
        }

        $locale = trim((string) $request->input('locale'));
        if ($locale === '') {
            return back()->with('error', 'Select a valid language.');
        }

        if (Schema::hasTable('languages')) {
            $language = Language::query()
                ->where('code', $locale)
                ->where('is_active', true)
                ->first();

            if (! $language) {
                return back()->with('error', 'Selected language is not available.');
            }
        }

        $request->session()->put('admin_locale', $locale);

        return back()->with('status', 'Language updated successfully.');
    }
}
