<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;

class ApiController extends Controller
{
    protected function success($data = null, array $meta = [], int $status = 200)
    {
        return response()->json([
            'data' => $data,
            'meta' => $meta,
        ], $status);
    }

    protected function error(string $message, int $code = 400, array $errors = [], array $meta = [])
    {
        return response()->json([
            'data' => null,
            'meta' => $meta,
            'errors' => $errors ?: [['code' => (string) $code, 'message' => $message]],
        ], $code);
    }

    protected function paginated(LengthAwarePaginator $paginator, array $extraMeta = [])
    {
        return $this->success($paginator->items(), array_merge([
            'current_page' => $paginator->currentPage(),
            'per_page' => $paginator->perPage(),
            'total' => $paginator->total(),
            'last_page' => $paginator->lastPage(),
        ], $extraMeta));
    }

    protected function escapeLike(string $value): string
    {
        return str_replace(['%', '_', '\\'], ['\\%', '\\_', '\\\\'], $value);
    }
}
