<?php

namespace App\Http\Controllers\Api;

use App\Models\SystemSetting;
use App\Support\LocaleSettings;
use App\Support\SecuritySettings;
use App\Support\SocialLoginSettings;
use Illuminate\Support\Facades\Schema;

class PublicSettingsController extends ApiController
{
    public function show()
    {
        $payload = [];

        if (Schema::hasTable('system_settings')) {
            $stored = SystemSetting::query()->value('payload');
            if (is_string($stored)) {
                $decoded = json_decode($stored, true);
                $stored = is_array($decoded) ? $decoded : [];
            }
            $payload = is_array($stored) ? $stored : [];
        }

        $defaults = [
            'general' => [
                'default_language' => LocaleSettings::defaultLocale(),
                'default_currency' => '',
                'default_timezone' => config('app.timezone'),
                'date_format' => '',
                'time_format' => '',
                'support_email' => '',
                'support_phone' => '',
                'enable_multi_language' => LocaleSettings::isEnabled(),
            ],
            'site' => [
                'site_name' => '',
                'site_logo' => null,
                'favicon' => null,
                'admin_logo' => null,
                'company_name' => '',
                'company_address' => '',
                'company_country_id' => null,
                'company_state_id' => null,
                'company_city_id' => null,
                'company_phone' => '',
                'business_hours' => '',
                'latitude' => '',
                'longitude' => '',
                'right_click_disable' => false,
                'uc_browser_block' => false,
            ],
            'footer' => [
                'footer_logo' => null,
                'footer_social' => [
                    'facebook' => '',
                    'x' => '',
                    'linkedin' => '',
                    'instagram' => '',
                    'whatsapp' => '',
                ],
                'app_links' => [
                    'android' => '',
                    'ios' => '',
                    'direct' => '',
                ],
            ],
            'seo' => [
                'meta_title' => '',
                'meta_description' => '',
                'meta_keywords' => '',
                'sitemap_enabled' => false,
                'robots_txt' => '',
                'llm_txt' => '',
            ],
            'gdpr' => [
                'gdpr_enabled' => false,
                'gdpr_message' => '',
                'gdpr_accept_label' => 'Accept',
                'gdpr_decline_label' => 'Decline',
            ],
            'maintenance' => [
                'maintenance_enabled' => false,
                'maintenance_message' => '',
            ],
            'extensions' => [
                'analytics' => [
                    'google_enabled' => false,
                    'google_measurement_id' => '',
                ],
                'adsense' => [
                    'adsense_enabled' => false,
                    'adsense_client_id' => '',
                ],
                'facebook' => [
                    'pixel_enabled' => false,
                    'pixel_id' => '',
                ],
                'microsoft' => [
                    'uet_enabled' => false,
                    'uet_tag_id' => '',
                ],
                'social' => [
                    'og_enabled' => false,
                    'og_title' => '',
                    'og_description' => '',
                    'og_image' => null,
                ],
            ],
        ];

        $settings = array_replace_recursive($defaults, $payload);
        $security = SecuritySettings::get();

        return $this->success([
            'settings' => $settings,
            'security' => [
                'captcha_enabled' => (bool) ($security['captcha_enabled'] ?? false),
                'captcha_site_key' => (string) ($security['captcha_site_key'] ?? ''),
                'max_login_attempts' => (int) ($security['max_login_attempts'] ?? 5),
                'lockout_minutes' => (int) ($security['lockout_minutes'] ?? 1),
            ],
            'social_providers' => SocialLoginSettings::enabledProviders(),
            'event_types' => config('events.types', []),
        ]);
    }
}
