<?php

namespace App\Http\Controllers;

use App\Models\ClientSelection;
use App\Models\Event;
use App\Models\EventMedia;
use Illuminate\Http\Request;

class ClientSelectionController extends Controller
{
    public function toggle(Request $request, Event $event, EventMedia $media)
    {
        if (! $this->tokenMatches($request, $event)) {
            abort(404);
        }

        if ($media->event_id !== $event->id) {
            abort(404);
        }

        $sessionId = $request->session()->getId();

        $existing = ClientSelection::where([
            'event_id' => $event->id,
            'event_media_id' => $media->id,
            'session_id' => $sessionId,
        ])->first();

        if ($existing) {
            $existing->delete();

            return response()->json(['selected' => false]);
        }

        ClientSelection::create([
            'event_id' => $event->id,
            'event_media_id' => $media->id,
            'session_id' => $sessionId,
            'guest_name' => $request->session()->get("guest_name_{$event->id}"),
            'guest_email' => $request->session()->get("guest_email_{$event->id}"),
        ]);

        return response()->json(['selected' => true]);
    }

    public function list(Request $request, Event $event)
    {
        if (! $this->tokenMatches($request, $event)) {
            abort(404);
        }

        $sessionId = $request->session()->getId();

        $selectedIds = ClientSelection::where([
            'event_id' => $event->id,
            'session_id' => $sessionId,
        ])->pluck('event_media_id')->toArray();

        return response()->json(['selected_ids' => $selectedIds]);
    }

    private function tokenMatches(Request $request, Event $event): bool
    {
        $token = (string) $request->query('token', $request->input('token', ''));

        return $token !== '' && hash_equals($event->share_token ?? '', $token);
    }
}
