<?php

namespace App\Http\Middleware;

use App\Models\SystemSetting;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Str;
use Symfony\Component\HttpFoundation\Response;

class EnsureBrowserAllowed
{
    public function handle(Request $request, Closure $next): Response
    {
        if (app()->runningInConsole()) {
            return $next($request);
        }

        try {
            if (! Schema::hasTable('system_settings')) {
                return $next($request);
            }
        } catch (\Exception $e) {
            return $next($request);
        }

        $payload = SystemSetting::query()->value('payload');
        if (is_string($payload)) {
            $decoded = json_decode($payload, true);
            $payload = is_array($decoded) ? $decoded : [];
        }

        $site = is_array($payload) ? ($payload['site'] ?? []) : [];
        $blockUc = filter_var($site['uc_browser_block'] ?? false, FILTER_VALIDATE_BOOLEAN);

        if (! $blockUc) {
            return $next($request);
        }

        $userAgent = $request->userAgent();
        if (! $userAgent) {
            return $next($request);
        }

        $agent = Str::lower($userAgent);
        $blockedTokens = ['ucbrowser', 'ucweb', 'ucbrowsermini', 'uc mini', 'ucmini'];

        foreach ($blockedTokens as $token) {
            if (Str::contains($agent, $token)) {
                return response()->view('browser-blocked', [
                    'message' => 'This browser is not supported. Please switch to Chrome, Edge, or Safari.',
                ], 403);
            }
        }

        return $next($request);
    }
}
