<?php

namespace App\Http\Middleware;

use App\Support\GuestTokenService;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureGuestToken
{
    public function handle(Request $request, Closure $next): Response
    {
        if ($request->user()) {
            return $next($request);
        }

        $token = trim((string) ($request->header('X-Guest-Token') ?: $request->query('guest_token', '')));

        if ($token === '') {
            return response()->json([
                'data' => null,
                'meta' => [],
                'errors' => [['code' => '401', 'message' => 'Guest access token is required.']],
            ], 401);
        }

        $payload = app(GuestTokenService::class)->validate($token);

        if (! $payload) {
            return response()->json([
                'data' => null,
                'meta' => [],
                'errors' => [['code' => '401', 'message' => 'Guest access token is invalid or expired.']],
            ], 401);
        }

        $request->attributes->set('guest_event_id', (int) ($payload['event_id'] ?? 0));

        return $next($request);
    }
}
