<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureInstalled
{
    public function handle(Request $request, Closure $next): Response
    {
        $installed = file_exists(storage_path('installed'));
        $isInstallRoute = str_starts_with(trim($request->getPathInfo(), '/'), 'install');

        // When app is not installed, force file session (no encryption) BEFORE CSRF runs
        if (! $installed) {
            config([
                'session.driver' => 'file',
                'session.encrypt' => false,
            ]);
        }

        if (! $installed && ! $isInstallRoute) {
            return redirect('/install');
        }

        if ($installed && $isInstallRoute) {
            return redirect('/');
        }

        return $next($request);
    }
}
