<?php

namespace App\Http\Middleware;

use App\Models\Language;
use App\Support\LocaleSettings;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Schema;
use Symfony\Component\HttpFoundation\Response;

class SetApiLocale
{
    public function handle(Request $request, Closure $next): Response
    {
        $defaultLocale = LocaleSettings::defaultLocale();
        $locale = $defaultLocale;

        if (LocaleSettings::isEnabled()) {
            $requested = trim((string) ($request->header('X-Locale') ?: $request->query('locale', '')));

            if ($requested !== '' && $this->isLocaleAvailable($requested)) {
                $locale = $requested;
            }
        }

        app()->setLocale($locale);

        return $next($request);
    }

    private function isLocaleAvailable(string $locale): bool
    {
        try {
            if (! Schema::hasTable('languages')) {
                return true;
            }
        } catch (\Exception $e) {
            return true;
        }

        return Language::query()
            ->where('code', $locale)
            ->where('is_active', true)
            ->exists();
    }
}
