<?php

namespace App\Http\Middleware;

use App\Models\Language;
use App\Support\LocaleSettings;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Schema;
use Symfony\Component\HttpFoundation\Response;

class SetLocale
{
    public function handle(Request $request, Closure $next): Response
    {
        $defaultLocale = LocaleSettings::defaultLocale();
        $locale = $defaultLocale;

        if (LocaleSettings::isEnabled()) {
            $sessionLocale = (string) $request->session()->get('admin_locale', $defaultLocale);

            if ($sessionLocale !== '' && $this->isLocaleAvailable($sessionLocale)) {
                $locale = $sessionLocale;
            } else {
                $locale = $defaultLocale;
            }
        }

        app()->setLocale($locale);

        return $next($request);
    }

    private function isLocaleAvailable(string $locale): bool
    {
        try {
            if (! Schema::hasTable('languages')) {
                return true;
            }
        } catch (\Exception $e) {
            return true;
        }

        return Language::query()
            ->where('code', $locale)
            ->where('is_active', true)
            ->exists();
    }
}
