<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class SetStorageUrl
{
    public function handle(Request $request, Closure $next)
    {
        $baseUrl = rtrim($request->getSchemeAndHttpHost() . $request->getBasePath(), '/');
        $storagePath = public_path('storage');
        
        if (!is_link($storagePath)) {
            if (!file_exists($storagePath)) {
                @mkdir($storagePath, 0755, true);
            }
            
            // Force the public disk to use the physical public directory as root
            config(['filesystems.disks.public.root' => $storagePath]);
        }

        if ($baseUrl !== '') {
            config([
                'app.url' => $baseUrl,
                'filesystems.disks.public.url' => $baseUrl . '/storage',
            ]);
        }

        return $next($request);
    }
}
