<?php

namespace App\Http\Requests\Admin;

use App\Support\EventMediaSettings;
use Illuminate\Foundation\Http\FormRequest;

class ChunkEventMediaRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $chunkSize = (int) EventMediaSettings::getValue('chunk_size', config('events.media.chunk_size', 5242880));
        $chunkMaxKb = (int) ceil($chunkSize / 1024);

        return [
            'upload_id' => ['required', 'string', 'max:120'],
            'chunk_index' => ['required', 'integer', 'min:0'],
            'total_chunks' => ['required', 'integer', 'min:1'],
            'file_name' => ['required', 'string', 'max:255'],
            'file_type' => ['required', 'string', 'max:50'],
            'file_size' => ['nullable', 'integer', 'min:1'],
            'chunk' => ['required', 'file', 'max:' . $chunkMaxKb],
            'chunk_checksum' => ['nullable', 'string', 'size:64'], // SHA256 hex - optional for backward compatibility
        ];
    }
}
