<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreActivityLogRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $types = array_keys(config('system.activity_types', []));

        return [
            'user_id' => ['nullable', 'integer', 'exists:users,id'],
            'action' => ['required', 'string', Rule::in($types)],
            'subject_type' => ['nullable', 'string', 'max:120'],
            'subject_id' => ['nullable', 'integer', 'min:1'],
            'description' => ['nullable', 'string'],
            'ip_address' => ['nullable', 'ip'],
            'user_agent' => ['nullable', 'string'],
            'logged_at' => ['nullable', 'date'],
        ];
    }
}
