<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreCityRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'state_id' => ['required', 'exists:states,id'],
            'name' => [
                'required',
                'string',
                'max:150',
                Rule::unique('cities', 'name')->where('state_id', $this->input('state_id')),
            ],
            'is_active' => ['sometimes', 'boolean'],
        ];
    }
}
