<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreCountryRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:150', Rule::unique('countries', 'name')],
            'iso2' => ['nullable', 'string', 'size:2', Rule::unique('countries', 'iso2')],
            'iso3' => ['nullable', 'string', 'size:3', Rule::unique('countries', 'iso3')],
            'phone_code' => ['nullable', 'string', 'max:10', 'regex:/^[0-9]+$/'],
            'is_active' => ['sometimes', 'boolean'],
            'auto_import' => ['sometimes', 'boolean'],
        ];
    }
}
