<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreCurrencyRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:120', Rule::unique('currencies', 'name')],
            'code' => ['required', 'string', 'max:10', 'regex:/^[A-Za-z0-9_-]+$/', Rule::unique('currencies', 'code')],
            'symbol' => ['nullable', 'string', 'max:20'],
            'precision' => ['nullable', 'integer', 'min:0', 'max:6'],
            'exchange_rate' => ['nullable', 'numeric', 'min:0'],
            'is_active' => ['sometimes', 'boolean'],
        ];
    }
}
