<?php

namespace App\Http\Requests\Admin;

use App\Support\EventMediaSettings;
use Illuminate\Foundation\Http\FormRequest;

class StoreEventMediaRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $maxSize = (int) EventMediaSettings::getValue('max_file_size', config('events.media.max_file_size', 51200));

        return [
            'media' => ['required', 'array', 'min:1'],
            'media.*' => [
                'required',
                'file',
                'mimes:jpg,jpeg,png,webp,mp4',
                'max:' . $maxSize,
            ],
        ];
    }
}
