<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreEventRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $types = config('events.types', []);

        return [
            'name' => ['required', 'string', 'max:150'],
            'type' => ['required', 'string', Rule::in($types)],
            'event_date' => ['required', 'date'],
            'expiry_date' => ['nullable', 'date', 'after_or_equal:event_date'],
            'details' => ['nullable', 'string'],
            'hashtags' => ['nullable', 'string', 'max:500'],
            'notifications_enabled' => ['sometimes', 'boolean'],
            'is_active' => ['sometimes', 'boolean'],
            'guest_pin' => ['nullable', 'regex:/^[0-9]{4,8}$/'],
            'admin_pin' => ['nullable', 'regex:/^[0-9]{4,8}$/'],
            'google_drive_links' => ['nullable', 'string', 'max:5000'],
            'watermark_position' => ['nullable', Rule::in(array_keys(config('events.media.watermark.positions', [])))],
        ];
    }
}
