<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreLanguageRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:120', Rule::unique('languages', 'name')],
            'code' => ['required', 'string', 'max:20', 'regex:/^[A-Za-z0-9_-]+$/', Rule::unique('languages', 'code')],
            'native_name' => ['nullable', 'string', 'max:120'],
            'direction' => ['nullable', 'in:ltr,rtl'],
            'is_active' => ['sometimes', 'boolean'],
        ];
    }
}
