<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StorePlanRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:150'],
            'price' => ['required', 'numeric', 'min:0'],
            'offer_price' => ['nullable', 'numeric', 'min:0', 'lte:price'],
            'features' => ['nullable', 'array'],
            'features.*' => ['nullable', 'string', 'max:120'],
            'images_limit' => ['nullable', 'integer', 'min:0'],
            'events_limit' => ['nullable', 'integer', 'min:0'],
            'storage_limit_gb' => ['nullable', 'numeric', 'min:0'],
            'duration_type' => ['required', Rule::in(['months', 'lifetime'])],
            'duration_months' => [
                Rule::requiredIf($this->input('duration_type') === 'months'),
                'nullable',
                'integer',
                'min:1',
            ],
            'has_watermark' => ['sometimes', 'boolean'],
            'has_design_editor' => ['sometimes', 'boolean'],
            'is_active' => ['sometimes', 'boolean'],
        ];
    }
}
