<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreSecurityAuditLogRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $eventTypes = array_keys(config('security.audit_event_types', []));
        $statuses = array_keys(config('security.audit_statuses', []));

        return [
            'event_type' => ['required', 'string', Rule::in($eventTypes)],
            'status' => ['required', 'string', Rule::in($statuses)],
            'user_id' => ['nullable', 'integer', 'exists:users,id'],
            'ip_address' => ['nullable', 'string', 'max:64'],
            'user_agent' => ['nullable', 'string', 'max:1000'],
            'metadata' => ['nullable', 'string'],
            'logged_at' => ['nullable', 'date'],
        ];
    }
}
