<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreSupportTicketRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'subject' => ['required', 'string', 'max:180'],
            'message' => ['required', 'string'],
            'requester_name' => [
                'required',
                'string',
                'max:40',
                'regex:/^[A-Za-z][A-Za-z\s.\'-]*$/'
            ],
            'requester_email' => ['required', 'email', 'max:30'],
            'requester_phone' => [
                'nullable',
                'string',
                'max:15',
                'regex:/^\+?[0-9]+$/'
            ],
            'priority' => [
                'required',
                Rule::in(array_keys(config('support.priorities', [])))
            ],
            'status' => [
                'required',
                Rule::in(array_keys(config('support.statuses', [])))
            ],
            'is_active' => ['sometimes', 'boolean'],
        ];
    }
}
