<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class StoreTicketAssignmentRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'support_ticket_id' => ['required', 'exists:support_tickets,id'],
            'assigned_to' => ['required', 'exists:users,id'],
            'note' => ['nullable', 'string', 'max:500'],
            'assigned_at' => ['nullable', 'date'],
            'is_active' => ['sometimes', 'boolean'],
        ];
    }
}
