<?php

namespace App\Http\Requests\Admin;

use App\Models\BlockedIp;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateBlockedIpRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $blockedIp = $this->route('blocked_ip');
        $blockedIpId = $blockedIp instanceof BlockedIp ? $blockedIp->id : null;

        return [
            'ip_address' => [
                'required',
                'string',
                'max:64',
                'regex:/^[0-9a-fA-F:\\/.]+$/',
                Rule::unique('blocked_ips', 'ip_address')->ignore($blockedIpId),
            ],
            'reason' => ['nullable', 'string', 'max:255'],
            'is_active' => ['sometimes', 'boolean'],
        ];
    }
}
