<?php

namespace App\Http\Requests\Admin;

use App\Models\BlogCategory;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateBlogCategoryRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $category = $this->route('blog_category');
        $categoryId = $category instanceof BlogCategory ? $category->id : null;

        return [
            'name' => ['required', 'string', 'max:150', Rule::unique('blog_categories', 'name')->ignore($categoryId)],
            'is_active' => ['sometimes', 'boolean'],
        ];
    }
}
