<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class UpdateBlogPostRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'title' => ['required', 'string', 'max:200'],
            'author_name' => ['nullable', 'string', 'max:150'],
            'category_id' => ['required', 'integer', 'exists:blog_categories,id'],
            'image' => ['nullable', 'image', 'mimes:jpg,jpeg,png,webp', 'max:10240'],
            'excerpt' => ['nullable', 'string', 'max:500'],
            'details' => ['nullable', 'string'],
            'tags' => ['nullable', 'string', 'max:500'],
            'is_bookmarked' => ['sometimes', 'boolean'],
            'is_active' => ['sometimes', 'boolean'],
            'published_at' => ['nullable', 'date'],
        ];
    }
}
