<?php

namespace App\Http\Requests\Admin;

use App\Models\City;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateCityRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $cityParam = $this->route('city');
        $cityId = $cityParam instanceof City ? $cityParam->id : $cityParam;
        $stateId = $this->input('state_id');

        return [
            'state_id' => ['required', 'exists:states,id'],
            'name' => [
                'required',
                'string',
                'max:150',
                Rule::unique('cities', 'name')
                    ->where('state_id', $stateId)
                    ->ignore($cityId),
            ],
            'is_active' => ['sometimes', 'boolean'],
        ];
    }
}
