<?php

namespace App\Http\Requests\Admin;

use App\Models\Country;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateCountryRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $countryParam = $this->route('country');
        $countryId = $countryParam instanceof Country ? $countryParam->id : $countryParam;

        return [
            'name' => ['required', 'string', 'max:150', Rule::unique('countries', 'name')->ignore($countryId)],
            'iso2' => ['nullable', 'string', 'size:2', Rule::unique('countries', 'iso2')->ignore($countryId)],
            'iso3' => ['nullable', 'string', 'size:3', Rule::unique('countries', 'iso3')->ignore($countryId)],
            'phone_code' => ['nullable', 'string', 'max:10', 'regex:/^[0-9]+$/'],
            'is_active' => ['sometimes', 'boolean'],
            'auto_import' => ['sometimes', 'boolean'],
        ];
    }
}
