<?php

namespace App\Http\Requests\Admin;

use App\Models\Coupon;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateCouponRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    protected function prepareForValidation(): void
    {
        if ($this->has('code')) {
            $this->merge([
                'code' => strtoupper(trim((string) $this->input('code'))),
            ]);
        }
    }

    public function rules(): array
    {
        $couponParam = $this->route('coupon');
        $couponId = $couponParam instanceof Coupon ? $couponParam->id : $couponParam;
        $isPercent = $this->input('discount_type') === 'percent';

        return [
            'name' => ['required', 'string', 'max:150'],
            'code' => ['required', 'string', 'max:50', 'alpha_dash', Rule::unique('coupons', 'code')->ignore($couponId)],
            'discount_type' => ['required', Rule::in(['percent', 'fixed'])],
            'discount_value' => array_merge(
                ['required', 'numeric', 'min:0.01'],
                $isPercent ? ['max:100'] : []
            ),
            'min_amount' => ['nullable', 'numeric', 'min:0'],
            'starts_at' => ['nullable', 'date'],
            'ends_at' => ['nullable', 'date', 'after_or_equal:starts_at'],
            'new_users_only' => ['sometimes', 'boolean'],
            'is_active' => ['sometimes', 'boolean'],
            'plans' => ['required', 'array'],
            'plans.*' => ['integer', 'exists:plans,id'],
        ];
    }
}
