<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class UpdateExtensionsRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $group = $this->route('group');

        return match ($group) {
            'analytics' => [
                'google_enabled' => ['sometimes', 'boolean'],
                'google_measurement_id' => ['nullable', 'string', 'max:50'],
            ],
            'adsense' => [
                'adsense_enabled' => ['sometimes', 'boolean'],
                'adsense_client_id' => ['nullable', 'string', 'max:50'],
            ],
            'facebook' => [
                'pixel_enabled' => ['sometimes', 'boolean'],
                'pixel_id' => ['nullable', 'string', 'max:50'],
            ],
            'microsoft' => [
                'uet_enabled' => ['sometimes', 'boolean'],
                'uet_tag_id' => ['nullable', 'string', 'max:50'],
            ],
            'social' => [
                'og_enabled' => ['sometimes', 'boolean'],
                'og_title' => ['nullable', 'string', 'max:70'],
                'og_description' => ['nullable', 'string', 'max:160'],
                'og_image' => ['nullable', 'image', 'mimes:jpg,jpeg,png,webp', 'max:10240'],
            ],
            default => [],
        };
    }
}
