<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdatePermissionRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $permissionId = $this->route('permission')?->id;
        $guard = $this->input('guard_name', 'web');

        return [
            'name' => [
                'required',
                'string',
                'max:150',
                'regex:/^[A-Za-z0-9._-]+$/',
                Rule::unique('permissions', 'name')
                    ->ignore($permissionId)
                    ->where(fn ($query) => $query->where('guard_name', $guard)),
            ],
            'guard_name' => ['nullable', 'string', 'max:50'],
        ];
    }
}
