<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class UpdateSecuritySettingsRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'max_login_attempts' => ['required', 'integer', 'min:1', 'max:20'],
            'lockout_minutes' => ['required', 'integer', 'min:1', 'max:120'],
            'captcha_enabled' => ['sometimes', 'boolean'],
            'captcha_site_key' => ['nullable', 'string', 'max:255'],
            'captcha_secret_key' => ['nullable', 'string', 'max:255'],
            'two_factor_admin_only' => ['sometimes', 'boolean'],
            'two_factor_issuer' => ['nullable', 'string', 'max:100'],
        ];
    }
}
