<?php

namespace App\Http\Requests\Admin;

use App\Models\State;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateStateRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $stateParam = $this->route('state');
        $stateId = $stateParam instanceof State ? $stateParam->id : $stateParam;
        $countryId = $this->input('country_id');

        return [
            'country_id' => ['required', 'exists:countries,id'],
            'name' => [
                'required',
                'string',
                'max:150',
                Rule::unique('states', 'name')
                    ->where('country_id', $countryId)
                    ->ignore($stateId),
            ],
            'code' => ['nullable', 'string', 'max:10'],
            'is_active' => ['sometimes', 'boolean'],
        ];
    }
}
