<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateSystemLogRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $levels = array_keys(config('system.log_levels', []));

        return [
            'level' => ['required', 'string', Rule::in($levels)],
            'source' => ['nullable', 'string', 'max:120'],
            'message' => ['required', 'string'],
            'context' => ['nullable', 'string'],
            'logged_at' => ['nullable', 'date'],
        ];
    }
}
