<?php

namespace App\Http\Requests\Api;

use Illuminate\Foundation\Http\FormRequest;

class PublicSupportTicketRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'subject' => ['required', 'string', 'max:180'],
            'message' => ['required', 'string'],
            'requester_name' => ['required', 'string', 'max:40', 'regex:/^[A-Za-z][A-Za-z\s.\'-]*$/'],
            'requester_email' => ['required', 'email', 'max:30'],
            'requester_phone' => ['nullable', 'string', 'max:15', 'regex:/^\+?[0-9]+$/'],
        ];
    }
}
