<?php

namespace App\Http\Requests\Api;

use Illuminate\Foundation\Http\FormRequest;

class RegisterRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:40', 'regex:/^[A-Za-z][A-Za-z\s.\'-]*$/'],
            'email' => ['required', 'email', 'max:30', 'unique:users,email'],
            'phone' => ['nullable', 'string', 'max:15', 'regex:/^\+?[0-9]+$/'],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ];
    }
}
