<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\DB;

/**
 * Dispatches ProcessEventMedia jobs in bulk from the queue worker,
 * so the HTTP request returns instantly instead of waiting for N inserts.
 */
class DispatchMediaProcessing implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $timeout = 300;

    public function __construct(public array $mediaIds)
    {
    }

    public function handle(): void
    {
        // Dispatch in batches of 100 within transactions for speed
        foreach (array_chunk($this->mediaIds, 100) as $chunk) {
            DB::transaction(function () use ($chunk) {
                foreach ($chunk as $id) {
                    ProcessEventMedia::dispatch($id);
                }
            });
        }
    }
}
