<?php

namespace App\Jobs;

use App\Models\Event;
use App\Services\GoogleDriveImportService;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Support\Facades\Log;

class ProcessGoogleDriveImport implements ShouldQueue
{
    use Queueable;

    public int $tries = 60;
    public int $timeout = 120;

    public function __construct(
        private int $eventId,
        private int $batchSize = 5,
        private int $maxSeconds = 30
    ) {
    }

    public function handle(GoogleDriveImportService $driveImporter): void
    {
        $event = Event::find($this->eventId);
        if (! $event) {
            Log::warning('ProcessGoogleDriveImport: Event not found', ['event_id' => $this->eventId]);
            return;
        }

        $result = $driveImporter->runForEvent($event, $this->batchSize, $this->maxSeconds);

        if ($result && in_array($result->status, ['discovering', 'pending', 'running'], true)) {
            self::dispatch($this->eventId, $this->batchSize, $this->maxSeconds)
                ->delay(now()->addSeconds(2));
        }
    }
}
