<?php

namespace App\Models;

use App\Events\AdminNotificationCreated;
use Illuminate\Database\Eloquent\Model;

class ActivityLog extends Model
{
    protected $fillable = [
        'user_id',
        'action',
        'subject_type',
        'subject_id',
        'description',
        'ip_address',
        'user_agent',
        'logged_at',
    ];

    protected $casts = [
        'logged_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    protected static function booted(): void
    {
        static::created(function (ActivityLog $log) {
            if (app()->runningInConsole()) {
                return;
            }

            event(new AdminNotificationCreated($log));
        });
    }
}
