<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BlockedLocation extends Model
{
    protected $fillable = [
        'country_id',
        'state_id',
        'city_id',
        'reason',
        'is_active',
        'created_by',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    public function country()
    {
        return $this->belongsTo(Country::class);
    }

    public function state()
    {
        return $this->belongsTo(State::class);
    }

    public function city()
    {
        return $this->belongsTo(City::class);
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
