<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BlogPost extends Model
{
    protected $fillable = [
        'title',
        'slug',
        'author_name',
        'category_id',
        'image',
        'excerpt',
        'details',
        'tags',
        'is_bookmarked',
        'is_active',
        'published_at',
        'created_by',
    ];

    protected $casts = [
        'tags' => 'array',
        'is_bookmarked' => 'boolean',
        'is_active' => 'boolean',
        'published_at' => 'datetime',
    ];

    public function category()
    {
        return $this->belongsTo(BlogCategory::class, 'category_id');
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
