<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ClientSelection extends Model
{
    protected $fillable = [
        'event_id',
        'event_media_id',
        'guest_name',
        'guest_email',
        'session_id',
    ];

    public function event()
    {
        return $this->belongsTo(Event::class);
    }

    public function media()
    {
        return $this->belongsTo(EventMedia::class, 'event_media_id');
    }
}
