<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Currency extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'code',
        'symbol',
        'precision',
        'exchange_rate',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'precision' => 'integer',
        'exchange_rate' => 'decimal:6',
    ];
}
