<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DriveImport extends Model
{
    use HasFactory;

    protected $fillable = [
        'event_id',
        'folder_link',
        'folder_id',
        'resource_key',
        'status',
        'total_files',
        'discovered_files',
        'processed_files',
        'failed_files',
        'next_page_token',
        'last_error',
        'started_at',
        'finished_at',
    ];

    protected $casts = [
        'total_files' => 'integer',
        'discovered_files' => 'integer',
        'processed_files' => 'integer',
        'failed_files' => 'integer',
        'started_at' => 'datetime',
        'finished_at' => 'datetime',
    ];

    public function event()
    {
        return $this->belongsTo(Event::class);
    }

    public function files()
    {
        return $this->hasMany(DriveImportFile::class);
    }
}
