<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DriveImportFile extends Model
{
    use HasFactory;

    protected $fillable = [
        'drive_import_id',
        'file_id',
        'file_name',
        'mime_type',
        'size',
        'status',
        'error',
    ];

    protected $casts = [
        'size' => 'integer',
    ];

    public function import()
    {
        return $this->belongsTo(DriveImport::class, 'drive_import_id');
    }
}
