<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class EventMediaFace extends Model
{
    protected $fillable = [
        'event_id',
        'event_media_id',
        'embedding',
        'confidence',
        'bbox',
    ];

    protected $casts = [
        'confidence' => 'float',
        'bbox' => 'array',
    ];

    public function media()
    {
        return $this->belongsTo(EventMedia::class, 'event_media_id');
    }

    public function event()
    {
        return $this->belongsTo(Event::class);
    }
}
