<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * FIX #20: Audit log for event media operations
 */
class EventMediaLog extends Model
{
    protected $fillable = [
        'event_media_id',
        'user_id',
        'action',
        'ip_address',
        'user_agent',
        'metadata',
    ];

    protected $casts = [
        'metadata' => 'array',
    ];

    public function eventMedia()
    {
        return $this->belongsTo(EventMedia::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Create a log entry for an action
     */
    public static function log(
        EventMedia $media,
        string $action,
        ?array $metadata = null
    ): self {
        return static::create([
            'event_media_id' => $media->id,
            'user_id' => auth()->id(),
            'action' => $action,
            'ip_address' => request()?->ip(),
            'user_agent' => request()?->userAgent(),
            'metadata' => $metadata,
        ]);
    }
}
